/*****************************************************************************************************************************************
** DT9062 Arduino-Library
** Einlesen des Displays eines DT9062-Multimeters
** ber die serielle Schnittstelle in einen Arduino
** Sowohl HardwareSerial- als auch SoftwareSerial-Ports knnen benutzt werden.
** Version: 1.0

** Software License Agreement
** Copyright (c) 2020 by Klaus Rittmeier
** All rights reserved.

** Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

**  Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
**  Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
**  Neither the name of the copyright owners nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.

** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
** INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
** IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
** OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
** OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

********************************************************************************************************************************************/

#ifndef __DT9062_H
#define __DT9062_H

#include <stream.h>

class Dt9062
{
public:
				Dt9062();
	void		connect(Stream &serial);
	bool        available();			// wird in der loop()-Funktion zyklisch aufgerufen.
	const char *info() const { return _info; }		// Info-Zeile des Displays
	float       value() const { return _value; }		// Mazahl
	const char *unit() const { return _unit; }		// Maeinheit
	const char *current() const {return _current; }	// AC oder DC

private:
	Stream *pSerial;
	unsigned char buffer[16];
	int bufferindex;
	float _value;
	char _current[4];
	char _unit[6];
	char _info[36];

	static int  ziffer(unsigned char byte1, unsigned char byte2);
	void setValue();
	void setCurrent();
	void setUnit();
	void setInfo();
};


#endif // __DT9062_H
